// $Id: HNSSortedTableView.h,v 1.1.1.1 2003/01/05 22:08:48 hns Exp $
//
//  HNSSortedTableView.h
//  CocoaBasic
//
//  Created by Dr. H. Nikolaus Schaller on Wed Jul 03 2002.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

// make an instance of this class the dataSource of a NSTableView

@interface HNSSortedTableView : NSTableView {
//	NSTableView *tableView;			// reference to controlled table view
	IBOutlet id dataSource;			// real data source
	int *index;						// indirect index
	unsigned isize;					// size of index
	int sortCol;					// sorting column
	BOOL backwards;					// sorting order
//	id target;						// saved target for actions
//	SEL action;						// saved single click
//	SEL doubleAction;				// saved double click
}

// make index and sort according to specified column

- (void) setSortColumn:(int) col descending:(BOOL) flag;			// -1 or otherwise invalid: don't sort
- (int) sortColumn;
- (BOOL) isSortingAscending;
- (BOOL) isSortingDescending;
	// - (void) setSortByClick:(BOOL) flag;

// translation between table (sorted view) and (raw) data
- (int) table2data:(int) rowIndex;	// table index (i.e. visible row number) to data index
- (int) data2table:(int) rowIndex;	// data index to visible row number

// return data row (not table row)
- (int)clickedDataRow;
- (int)editedDataRow;
- (int)dataRowAtPoint:(NSPoint)aPoint;
- (int)selectedDataRow;

// pass data row (not table row)
- (void)deselectDataRow:(int)rowIndex;
- (void)drawDataRow:(int)rowIndex clipRect:(NSRect)clipRect;
- (void)editColumn:(int)columnIndex dataRow:(int)rowIndex withEvent:(NSEvent *)theEvent select:(BOOL)flag;
- (NSRect)frameOfCellAtColumn:(int)columnIndex dataRow:(int)rowIndex;
- (NSRect)rectOfDataRow:(int)rowIndex;
- (void)setDropDataRow:(int)row dropOperation:(NSTableViewDropOperation)operation;
- (NSEnumerator *)selectedDataRowEnumerator;
- (BOOL)isDataRowSelected:(int)rowIndex;
- (void)scrollDataRowToVisible:(int)rowIndex;
- (void)selectDataRow:(int)rowIndex byExtendingSelection:(BOOL)flag;

// dataSource interface protocol
- (int) numberOfRowsInTableView:(NSTableView *)aTableView;
- (id) tableView:(NSTableView *)aTableView objectValueForTableColumn:(NSTableColumn *)aTableColumn row:(int)rowIndex;

@end
